;Peripheral addresses

VSEL1i	equ	H'00'	;isolator channel
VSEL1m	equ	H'01'	;monitor channel (VCR)
VSEL1t	equ	H'02'	;transmitter channel
VSEL1s	equ	H'03'	;sync detector channel
VMUX2_1	equ	H'04'
VMUX2_2	equ	H'05'
VMUX2_3	equ	H'06'
VMUX2_4	equ	H'07'
AMUX1	equ	H'08'	;output to monitor
AMUX2	equ	H'09'	;output to TX
UARTCS	equ	H'0A'	;selects UART on 3100CT2
CS8870	equ	H'0B'	;selects MF detector
OSGSEL	equ	H'0C'	;selects on-screen graphics port
TCGSEL	equ	H'0D'	;selects testcard paging port
IDSEL	equ	H'0E'	;selects morse generator port
USRBSEL	equ	H'0F'	;selects relay bank B control
VCRSEL	equ	H'10'	;selects VCR (IR) control port
METSEL	equ	H'11'	;selects Meteosat control port
ANTSEL	equ	H'12'	;selects antenna control port
USRASEL equ	H'13'	;selects relay bank A control
SYNCDET	equ	H'14'	;selects sync detector port
DEC_15	equ	H'15'
DEC_16	equ	H'16'
DEC_17	equ	H'17'
DEC_18	equ	H'18'
DEC_19	equ	H'19'
DEC_1A	equ	H'1A'
DEC_1B	equ	H'1B'
DEC_1C	equ	H'1C'
DEC_1D	equ	H'1D'
DEC_1E	equ	H'1E'
PARK	equ	H'1F'

;16C84 PORTA pin names:
A0	equ	0
A1	equ	1
A2	equ	2
A3	equ	3
A4	equ	4

;16C84 PORTB pin names: (RB0 is the UART interrupt input)
CS	equ	1			;UART chip select
SCLK	equ	2			;UART SPI clock
SDIN	equ	3			;UART data input (from 3100)
SDOUT	equ	4			;UART data output (to 3100)

;Program constants (note: MY_ID increases by 1 if RB7 is held high)

PAGETIME	equ H'1E'		;tcg page display period in seconds
MY_ID		equ H'01'		;01 = MF prefix for this device
BAUD		equ H'02'		;02 = 57600 Baud
MF_WINDOW	equ H'06'		;seconds allowed between * and #
OSG_DISP_TIME	equ H'07'		;seconds to show on-screen ident
FUNCTION_TIME	equ H'78'		;seconds timed function period
ID_TIME		equ H'0A'		;minutes before ID is sent
REWIND_TIME	equ H'1F'		;minutes before auto rewind

;Video input channel definitions

TCG_VID		equ H'00'		;input from TCG board
ISO_VID		equ H'01'		;input via isolator board (front 'D')
RX_VID		equ H'02'		;input from RX (rear 1)
EXT1_VID	equ H'03'		;input from EXT1 connector (rear 2)
EXT2_VID	equ H'04'		;input from EXT2 connector (rear 3)
EXT3_VID	equ H'05'		;input from EXT3 connector (front 1)
EXT4_VID	equ H'06'		;input from EXT4 connector (front 2)
EXT5_VID	equ H'07'		;input from EXT5 (unused)

;Audio input channel definitions

EXT6_AUD	equ H'00'		;spare input
EXT4_AUD	equ H'01'		;input from EXT4 connector (front 2)
EXT2_AUD	equ H'02'		;input from EXT2 connector (rear 3)
EXT5_AUD	equ H'03'		;spare input
EXT3_AUD	equ H'04'		;input from EXT3 connector (front 1)
ISO_AUD		equ H'05'		;input from isolator board (front 'D')
EXT1_AUD	equ H'06'		;input from EXT1 connector (rear 2)
RX_AUD		equ H'07'		;input from RX (rear 1)


;VCR "IR" command codes

VCR_rewind	equ H'02'		;(cmd 2. rewind)
VCR_stepdown	equ H'0C'		;(cmd C. channel -)
     
